<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
// DBSEO "Blog" classes

/**
* Lets you construct & lookup Blog Attachment URLs
*/
class DBSEO_Rewrite_Blog
{
	public static $format = 'Blog_Blog';
	public static $structure = 'blog.php?u=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		if (empty($urlInfo['user_id']) AND isset($urlInfo['user_name']))
		{
			// We need to look up user ID
			$urlInfo['user_id'] = DBSEO::reverseUsername($urlInfo['user_name']);
		}

		if ($urlInfo['user_id'])
		{
			// We had the user ID!
			return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['user_id'], $urlInfo['page']);
		}

		// Fail :(
		return '';
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		$data['userid'] = intval($data['bloguserid'] ? $data['bloguserid'] : $data['u']);
		if ($data['userid'])
		{
			// Grab our user info
			DBSEO::getUserInfo($data['userid']);
			$userInfo = DBSEO::$cache['userinfo'][$data['userid']];
		}
		
		if (!$userInfo['userid'])
		{
			// User didn't exist
			return '';
		}

		// Handle userid and username
		$replace['%user_id%'] 	= $userInfo['userid'];
		$replace['%user_name%'] = DBSEO::filterText($userInfo['username'], NULL, false, true, true);

		if ($data['page'])
		{
			// We had a paged blog
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);
		
		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl,'://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}

	
	/**
	 * Gets any extra information needed
	 *
	 * @param mixed $blogIds
	 * 
	 * @return array
	 */
	public static function getInfo($blogIds, $blogUser = false, $comment = false)
	{
		if ($comment)
		{
			$table  	= 'blog_text';
			$idField 	= 'blogtextid';
			$userId 	= 'bloguserid';
			$fields 	= 'blog.userid, blog.username, blog.blogtextid, blog.blogid, blog.state';
			$joins 		= '';
		}
		else
		{
			$table 		= 'blog';
			$idField 	= 'blogid';
			$userId 	= 'userid';
			$fields 	= 'blog.userid, blog.username, blog.blogid, blog.title, blog.state, blogtext.pagetext';
			$joins 		= 'LEFT JOIN $blog_text AS blogtext ON(blogtext.blogtextid = blog.firstblogtextid)';
		}

		if (!$blogIds)
		{
			return array();
		}

		if (!is_array($blogIds))
		{
			// Ensure this is an array
			$blogIds = array($blogIds);
		}
		
		foreach ($blogIds as $key => $id)
		{
			if (($info = DBSEO::$datastore->fetch($table . 'info.' . $id)) === false)
			{
				// We don't have this cached
				continue;
			}

			// We had this cached, cache it internally too
			DBSEO::$cache['blog'][$id] = $info;
		}

		$queryList = array();
		foreach ($blogIds as $key => $blogId)
		{
			if (!isset(DBSEO::$cache[$table][$blogId]))
			{
				// Ensure this is done
				$queryList[$key] = intval($blogId);
			}
		}

		if (count($queryList))
		{
			$info = DBSEO::$db->generalQuery('
				SELECT bloguser.*, ' . $fields . '
				FROM $' . $table . ' AS blog
				LEFT JOIN $blog_user AS bloguser ON(bloguser.bloguserid = blog.' . $userId . ')
				' . $joins . '
				WHERE blog.' . $idField . ' IN (' . implode(',', $queryList) . ')
			', false);
			foreach ($info as $arr)
			{
				// Build the cache
				DBSEO::$datastore->build($table . 'info.' . $arr[$idField], $arr);

				// Cache this info
				DBSEO::$cache[$table][$arr[$idField]] = $arr;
			}
		}

		$blogInfo = array();
		if (count($blogIds) == 1)
		{
			// We have only one, return only one
			$blogInfo = DBSEO::$cache[$table][$blogIds[0]];
		}
		else
		{
			foreach ($blogIds as $key => $blogId)
			{
				// Create this array
				$blogInfo[$blogId] = DBSEO::$cache[$table][$blogId];
			}
		}

		return $blogInfo;
	}
}

// #############################################################################
// DBSEO "PrintThread URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_Blog_Page extends DBSEO_Rewrite_Blog
{
	public static $format = 'Blog_Blog_Page';
	public static $structure = 'blog.php?u=%d&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}

// #############################################################################
// DBSEO "BlogEntry URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BlogEntry
{
	public static $format = 'Blog_BlogEntry';
	public static $structure = '%s.php?b=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return sprintf((is_null($structure) ? self::$structure : $structure), DBSEO::$config['_blogentry'], $urlInfo['blog_id'], $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		// Shorthand
		$data['blogid'] = $data['b'] ? $data['b'] : $data['blogid'];
		if (!$data['blogid'])
		{
			// Blogid didn't exist
			return '';
		}

		// Get blog info here
		$blogInfo = DBSEO::getBlogInfo($data['blogid']);

		if (!$blogInfo['blogid'])
		{
			// Blogid didn't exist
			return '';
		}

		// Ensure this is set
		$data['userid'] = intval($data['bloguserid'] ? $data['bloguserid'] : $data['u']);
		$data['userid'] = $data['userid'] ? $data['userid'] : $blogInfo['userid'];

		if ($data['userid'])
		{
			// Grab our user info
			DBSEO::getUserInfo($data['userid']);
			$userInfo = DBSEO::$cache['userinfo'][$data['userid']];
		}
		
		if (!$userInfo['userid'])
		{
			// User didn't exist
			return '';
		}

		// Handle userid and username
		$replace['%user_id%'] 	= $userInfo['userid'];
		$replace['%user_name%'] = DBSEO::filterText($userInfo['username'], NULL, false, true, true);

		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_rewrite_blogentry_smarttitle'])
		{
			// Content filter
			$blogInfo['seotitle'] = DBSEO::contentFilter($blogInfo['pagetext']);
		}
		/*DBTECH_PRO_END*/

		if (!$blogInfo['seotitle'])
		{
			// Normal filter
			$blogInfo['seotitle'] = DBSEO::filterText($blogInfo['title']);
		}

		// Set SEO title
		$blogInfo['seotitle'] = $blogInfo['seotitle'] ? $blogInfo['seotitle'] : 'a';

		// Handle blog info
		$replace['%blog_id%'] 		= $blogInfo['blogid'];
		$replace['%blog_title%'] 	= $blogInfo['seotitle'];

		if ($data['page'])
		{
			// We had a paged blog
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);

		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl,'://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "BlogEntry URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BlogEntry_Page extends DBSEO_Rewrite_BlogEntry
{
	public static $format = 'Blog_BlogEntry_Page';
	public static $structure = '%s.php?b=%d&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}


// #############################################################################
// DBSEO "BlogCategoryCore URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BlogCategoryCore
{
	/**
	 * Gets any extra information needed
	 *
	 * @param mixed $blogCategoryIds
	 * 
	 * @return array
	 */
	public static function getInfo($blogCategoryIds)
	{
		$blogCategoryInfo = array();

		if (!is_array($blogCategoryIds))
		{
			// Ensure this is an array
			$blogCategoryIds = array($blogCategoryIds);
		}

		foreach ($blogCategoryIds as $key => $id)
		{
			if (($info = DBSEO::$datastore->fetch('blogcatinfo.' . $id)) === false)
			{
				// We don't have this cached
				continue;
			}

			// We had this cached, cache it internally too
			DBSEO::$cache['blogcategory'][$id] = $info;
		}

		$queryList = array();
		foreach ($blogCategoryIds as $key => $blogCategoryId)
		{
			if (!isset(DBSEO::$cache['blogcategory'][$blogCategoryId]))
			{
				// Ensure this is done
				$queryList[$key] = intval($blogCategoryId);
			}
		}

		if (count($queryList))
		{
			$info = DBSEO::$db->generalQuery('
				SELECT blogcategoryid, title, userid
				FROM $blog_category
				WHERE blogcategoryid IN (' . implode(',', $queryList) . ')
			', false);
			foreach ($info as $arr)
			{
				// Build the cache
				DBSEO::$datastore->build('blogcatinfo.' . $arr['blogcategoryid'], $arr);

				// Cache this info
				DBSEO::$cache['blogcategory'][$arr['blogcategoryid']] = $arr;
			}
		}

		if (count($blogCategoryIds) == 1)
		{
			// We have only one, return only one
			$blogCategoryInfo = DBSEO::$cache['blogcategory'][$blogCategoryIds[0]];
		}
		else
		{
			foreach ($blogCategoryIds as $key => $blogCategoryId)
			{
				// Create this array
				$blogCategoryInfo[$blogCategoryId] = DBSEO::$cache['blogcategory'][$blogCategoryId];
			}
		}

		return $blogCategoryInfo;
	}
}



// #############################################################################
// DBSEO "BlogGlobalCategory URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BlogGlobalCategory extends DBSEO_Rewrite_BlogCategoryCore
{
	public static $format = 'Blog_BlogGlobalCategory';
	public static $structure = 'blog.php?blogcategoryid=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		if (isset($urlInfo['category_id']) AND $urlInfo['category_id'] == 0)
		{
			// Set this if we've got a strange ID
			$urlInfo['category_id'] = -1;
		}

		if (!$urlInfo['category_id'])
		{
			// Lookup blog category ID
			if (!$urlInfo['category_id'] = DBSEO::reverseObject('blogcat', $urlInfo['category_title'], 0))
			{
				// Uncategorised
				$urlInfo['category_id'] = -1;
			}
		}

		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['category_id'], $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		if ($data['blogcategoryid'])
		{
			if ($data['blogcategoryid'] == -1)
			{
				$categoryInfo = array('blogcategoryid' => 0, 'title' => DBSEO::$config['dbtech_dbseo_blog_category_undefined']);
			}
			else
			{
				$categoryInfo = self::getInfo($data['blogcategoryid']);
			}

			if (!isset($categoryInfo['seotitle']))
			{
				$categoryInfo['seotitle'] = DBSEO::filterText($categoryInfo['title']);
				if (preg_match('#[-_\s](?:post|print)?\d+$#', $categoryInfo['seotitle']) OR !$categoryInfo['seotitle'])
				{
					// Append what we need to the title
					$categoryInfo['seotitle'] .= ($categoryInfo['seotitle'] ? DBSEO::$config['dbtech_dbseo_rewrite_separator'] : '') . 'a';
				}

				// Set this
				DBSEO::$cache['blogcategory'][$categoryInfo['blogcategoryid']]['seotitle'] = $categoryInfo['seotitle'];
			}

			$replace['%category_id%'] = $categoryInfo['blogcategoryid'];
			$replace['%category_title%'] = $categoryInfo['seotitle'];
		}

		if ($data['page'])
		{
			// We had a paged blog
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "BlogGlobalCategory URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BlogGlobalCategory_Page extends DBSEO_Rewrite_BlogGlobalCategory
{
	public static $format = 'Blog_BlogGlobalCategory_Page';
	public static $structure = 'blog.php?blogcategoryid=%d&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}


// #############################################################################
// DBSEO "BlogCategory URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BlogCategory extends DBSEO_Rewrite_BlogCategoryCore
{
	public static $format = 'Blog_BlogCategory';
	public static $structure = 'blog.php?u=%d&blogcategoryid=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		if (empty($urlInfo['user_id']) AND isset($urlInfo['user_name']))
		{
			// Lookup user ID
			$urlInfo['user_id'] = DBSEO::reverseUsername($urlInfo['user_name']);
		}

		if (isset($urlInfo['category_id']) AND $urlInfo['category_id'] == 0)
		{
			// Set this if we've got a strange ID
			$urlInfo['category_id'] = -1;
		}

		if (!$urlInfo['category_id'])
		{
			// Lookup blog category ID
			if (!$urlInfo['category_id'] = DBSEO::reverseObject('blogcat', $urlInfo['category_title'], $urlInfo['user_id']))
			{
				// Uncategorised
				$urlInfo['category_id'] = -1;
			}
		}

		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['user_id'], $urlInfo['category_id'], $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		$data['userid'] = intval($data['bloguserid'] ? $data['bloguserid'] : $data['u']);
		if ($data['userid'])
		{
			// Grab our user info
			DBSEO::getUserInfo($data['userid']);
			$userInfo = DBSEO::$cache['userinfo'][$data['userid']];
		}
		
		if (!$userInfo['userid'])
		{
			// User didn't exist
			return '';
		}

		if ($data['blogcategoryid'])
		{
			if ($data['blogcategoryid'] == -1)
			{
				$categoryInfo = array('blogcategoryid' => 0, 'title' => DBSEO::$config['dbtech_dbseo_blog_category_undefined']);
			}
			else
			{
				$categoryInfo = self::getInfo($data['blogcategoryid']);
			}

			if (!isset($categoryInfo['seotitle']))
			{
				$categoryInfo['seotitle'] = DBSEO::filterText($categoryInfo['title']);
				if (preg_match('#[-_\s](?:post|print)?\d+$#', $categoryInfo['seotitle']) OR !$categoryInfo['seotitle'])
				{
					// Append what we need to the title
					$categoryInfo['seotitle'] .= ($categoryInfo['seotitle'] ? DBSEO::$config['dbtech_dbseo_rewrite_separator'] : '') . 'a';
				}

				// Set this
				DBSEO::$cache['blogcategory'][$categoryInfo['blogcategoryid']]['seotitle'] = $categoryInfo['seotitle'];
			}

			$replace['%category_id%'] = $categoryInfo['blogcategoryid'];
			$replace['%category_title%'] = $categoryInfo['seotitle'];
		}

		if ($data['page'])
		{
			// We had a paged blog
			$replace['%page%'] = $data['page'];
		}

		// Handle userid and username
		$replace['%user_id%'] 	= $userInfo['userid'];
		$replace['%user_name%'] = DBSEO::filterText($userInfo['username'], NULL, false, true, true);

		// Handle blog info
		$replace['%blog_id%'] 		= $blogInfo['blogid'];
		$replace['%blog_title%'] 	= DBSEO::filterText($blogInfo['title']);

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);
		
		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl,'://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "BlogCategory URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BlogCategory_Page extends DBSEO_Rewrite_BlogCategory
{
	public static $format = 'Blog_BlogCategory_Page';
	public static $structure = 'blog.php?u=%d&blogcategoryid=%d&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}


// #############################################################################
// DBSEO "BlogTag URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BlogTag
{
	public static $format = 'Blog_BlogTag';
	public static $structure = 'blog.php?tag=%s';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		if (DBSEO::$config['dbtech_dbseo_filter_blogtag'])
		{
			// Unfilter & encode blog tag
			$urlInfo['tag'] = urlencode(str_replace(array('&lt;', '&gt;', '&quot;', '&amp;'), array('<', '>', '"', '&'), DBSEO::reverseObject('tag', $urlInfo['tag'])));
		}

		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['tag'], $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		if ($data['tag'])
		{
			// Sort out the tag
			$replace['%tag%'] = DBSEO::filterTag($data['tag'], true);
		}

		if ($data['page'])
		{
			// We had a paged blog
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);
		
		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl,'://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "BlogTag URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BlogTag_Page extends DBSEO_Rewrite_BlogTag
{
	public static $format = 'Blog_BlogTag_Page';
	public static $structure = 'blog.php?tag=%s&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}


// #############################################################################
// DBSEO "BlogsByDay_Global URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BlogsByDay_Global
{
	public static $format = 'Blog_BlogsByDay_Global';
	public static $structure = 'blog.php?do=list&y=%d&m=%d&d=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['year'], $urlInfo['month'], $urlInfo['day'], $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		if ($data['page'])
		{
			// We had a paged blog
			$replace['%page%'] = $data['page'];
		}

		if ($data['y'])
		{
			$replace['%year%'] 	= $data['y'];
			$replace['%month%'] = $data['m'];
			$replace['%day%'] 	= $data['d'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);
		
		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl,'://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "BlogsByDay_Global URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BlogsByDay_Global_Page extends DBSEO_Rewrite_BlogsByDay_Global
{
	public static $format = 'Blog_BlogsByDay_Global_Page';
	public static $structure = 'blog.php?do=list&y=%d&m=%d&d=%d&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}


// #############################################################################
// DBSEO "BlogsByMonth_Global URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BlogsByMonth_Global
{
	public static $format = 'Blog_BlogsByMonth_Global';
	public static $structure = 'blog.php?do=list&y=%d&m=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['year'], $urlInfo['month'], $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		if ($data['page'])
		{
			// We had a paged blog
			$replace['%page%'] = $data['page'];
		}

		if ($data['y'])
		{
			$replace['%year%'] 	= $data['y'];
			$replace['%month%'] = $data['m'];
			$replace['%day%'] 	= $data['d'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);
		
		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl,'://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "BlogsByMonth_Global URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BlogsByMonth_Global_Page extends DBSEO_Rewrite_BlogsByMonth_Global
{
	public static $format = 'Blog_BlogsByMonth_Global_Page';
	public static $structure = 'blog.php?do=list&y=%d&m=%d&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}


// #############################################################################
// DBSEO "AllBlogs URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_AllBlogs
{
	public static $format = 'Blog_AllBlogs';
	public static $structure = 'blog.php?do=bloglist';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		if ($data['page'])
		{
			// We had a paged blog
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);
		
		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl,'://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "AllBlogs URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_AllBlogs_Page extends DBSEO_Rewrite_AllBlogs
{
	public static $format = 'Blog_AllBlogs_Page';
	public static $structure = 'blog.php?do=bloglist&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}


// #############################################################################
// DBSEO "RecentBlogEntries URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_RecentBlogEntries
{
	public static $format = 'Blog_RecentBlogEntries';
	public static $structure = 'blog.php?do=list';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		if ($data['page'])
		{
			// We had a paged blog
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);
		
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl, '://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "RecentBlogEntries URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_RecentBlogEntries_Page extends DBSEO_Rewrite_RecentBlogEntries
{
	public static $format = 'Blog_RecentBlogEntries_Page';
	public static $structure = 'blog.php?do=list&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}


// #############################################################################
// DBSEO "LatestBlogEntries URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_LatestBlogEntries
{
	public static $format = 'Blog_LatestBlogEntries';
	public static $structure = 'blog.php?do=list&span=24';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		if ($data['page'])
		{
			// We had a paged blog
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);
		
		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl,'://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "LatestBlogEntries URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_LatestBlogEntries_Page extends DBSEO_Rewrite_LatestBlogEntries
{
	public static $format = 'Blog_LatestBlogEntries_Page';
	public static $structure = 'blog.php?do=list&span=24&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}


// #############################################################################
// DBSEO "BestBlogEntries URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BestBlogEntries
{
	public static $format = 'Blog_BestBlogEntries';
	public static $structure = 'blog.php?do=list&blogtype=best';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		if ($data['page'])
		{
			// We had a paged blog
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);
		
		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl,'://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "BestBlogEntries URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BestBlogEntries_Page extends DBSEO_Rewrite_BestBlogEntries
{
	public static $format = 'Blog_BestBlogEntries_Page';
	public static $structure = 'blog.php?do=list&blogtype=best&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}


// #############################################################################
// DBSEO "BestBlogs URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BestBlogs
{
	public static $format = 'Blog_BestBlogs';
	public static $structure = 'blog.php?do=bloglist&blogtype=best';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();
		
		if ($data['page'])
		{
			// We had a paged blog
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);
		
		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl,'://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "BestBlogs URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BestBlogs_Page extends DBSEO_Rewrite_BestBlogs
{
	public static $format = 'Blog_BestBlogs_Page';
	public static $structure = 'blog.php?do=bloglist&blogtype=best&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}


// #############################################################################
// DBSEO "BlogComments URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BlogComments
{
	public static $format = 'Blog_BlogComments';
	public static $structure = 'blog.php?do=comments';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['page']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();
		
		if ($data['page'])
		{
			// We had a paged blog
			$replace['%page%'] = $data['page'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);
		
		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl,'://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}

// #############################################################################
// DBSEO "BlogComments URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BlogComments_Page extends DBSEO_Rewrite_BlogComments
{
	public static $format = 'Blog_BlogComments_Page';
	public static $structure = 'blog.php?do=comments&page=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		// Determine if we have a structure
		$structure = is_null($structure) ? self::$structure : $structure;

		// Now create the URL
		return parent::resolveUrl($urlInfo, $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		// Determine if we have a format
		$format = is_null($format) ? self::$format : $format;

		// Now create the URL
		return parent::createUrl($data, $format);
	}
}


// #############################################################################
// DBSEO "BlogComment URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BlogComment
{
	public static $format = 'Blog_BlogComment';
	public static $structure = 'blog.php?bt=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['comment_id']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		$data['blogtextid'] = $data['blogtextid'] ? $data['blogtextid'] : $data['bt'];
		if ($data['blogtextid'])
		{
			// We had a comment ID
			$replace['%comment_id%'] = intval($data['blogtextid']);
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);

		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl,'://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}


// #############################################################################
// DBSEO "NextBlogEntry URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_NextBlogEntry
{
	public static $format = 'Blog_NextBlogEntry';
	public static $structure = 'blog.php?b=%d&goto=next';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['blog_id']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		// Shorthand
		$data['blogid'] = $data['b'] ? $data['b'] : $data['blogid'];
		if (!$data['blogid'])
		{
			// Blogid didn't exist
			return '';
		}

		// Get blog info here
		$blogInfo = DBSEO::getBlogInfo($data['blogid']);

		if (!$blogInfo['blogid'])
		{
			// Blogid didn't exist
			return '';
		}

		// Ensure this is set
		$data['userid'] = intval($data['bloguserid'] ? $data['bloguserid'] : $data['u']);
		$data['userid'] = $data['userid'] ? $data['userid'] : $blogInfo['userid'];

		if ($data['userid'])
		{
			// Grab our user info
			DBSEO::getUserInfo($data['userid']);
			$userInfo = DBSEO::$cache['userinfo'][$data['userid']];
		}
		
		if (!$userInfo['userid'])
		{
			// User didn't exist
			return '';
		}

		// Handle userid and username
		$replace['%user_id%'] 	= $userInfo['userid'];
		$replace['%user_name%'] = DBSEO::filterText($userInfo['username'], NULL, false, true, true);

		// Handle blog info
		$replace['%blog_id%'] 		= $blogInfo['blogid'];
		$replace['%blog_title%'] 	= DBSEO::filterText($blogInfo['title']);

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);

		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl,'://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}


// #############################################################################
// DBSEO "PrevBlogEntry URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_PrevBlogEntry
{
	public static $format = 'Blog_PrevBlogEntry';
	public static $structure = 'blog.php?b=%d&goto=prev';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['blog_id']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		// Shorthand
		$data['blogid'] = $data['b'] ? $data['b'] : $data['blogid'];
		if (!$data['blogid'])
		{
			// Blogid didn't exist
			return '';
		}

		// Get blog info here
		$blogInfo = DBSEO::getBlogInfo($data['blogid']);

		if (!$blogInfo['blogid'])
		{
			// Blogid didn't exist
			return '';
		}

		// Ensure this is set
		$data['userid'] = intval($data['bloguserid'] ? $data['bloguserid'] : $data['u']);
		$data['userid'] = $data['userid'] ? $data['userid'] : $blogInfo['userid'];

		if ($data['userid'])
		{
			// Grab our user info
			DBSEO::getUserInfo($data['userid']);
			$userInfo = DBSEO::$cache['userinfo'][$data['userid']];
		}
		
		if (!$userInfo['userid'])
		{
			// User didn't exist
			return '';
		}

		// Handle userid and username
		$replace['%user_id%'] 	= $userInfo['userid'];
		$replace['%user_name%'] = DBSEO::filterText($userInfo['username'], NULL, false, true, true);

		// Handle blog info
		$replace['%blog_id%'] 		= $blogInfo['blogid'];
		$replace['%blog_title%'] 	= DBSEO::filterText($blogInfo['title']);

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);

		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl,'://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}


// #############################################################################
// DBSEO "CustomBlog URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_CustomBlog
{
	public static $format = 'Blog_CustomBlog';
	public static $structure = 'blog.php?cp=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['page_id']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		// Grab custom block info
		$customBlockInfo = DBSEO::getObjectInfo('blogcustomblock', $data['cp']);

		// In case we don't have $data['userid']
		DBSEO::getUserInfo($customBlockInfo['userid']);
		$userInfo = DBSEO::$cache['userinfo'][$customBlockInfo['userid']];

		$data['userid'] = intval($data['bloguserid'] ? $data['bloguserid'] : $data['u']);
		if ($data['userid'])
		{
			// Grab our user info
			DBSEO::getUserInfo($data['userid']);
			$userInfo = DBSEO::$cache['userinfo'][$data['userid']];
		}

		if (!$userInfo['userid'])
		{
			// User didn't exist
			return '';
		}

		// Handle userid and username
		$replace['%user_id%'] 	= $userInfo['userid'];
		$replace['%user_name%'] = DBSEO::filterText($userInfo['username'], NULL, false, true, true);

		// Handle page info
		$replace['%page_id%'] = intval($data['cp']);
		$replace['%page_title%'] = DBSEO::filterText($customBlockInfo['title']);

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);
		
		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl,'://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}


// #############################################################################
// DBSEO "BlogTags URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BlogTags
{
	public static $format = 'Blog_BlogTags';
	public static $structure = 'blog_tag.php';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return (is_null($structure) ? self::$structure : $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Handle the replacements
		$newUrl = $rawFormat;

		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl,'://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		if (strpos($newUrl, '%') !== false)
		{
			// We should not return true if any single variable remains
			return '';
		}

		// Return the new URL
		return $newUrl;
	}
}


// #############################################################################
// DBSEO "BlogFeedUser URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BlogFeedUser
{
	public static $format = 'Blog_BlogFeedUser';
	public static $structure = 'blog_external.php?bloguserid=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		if (empty($urlInfo['user_id']) AND isset($urlInfo['user_name']))
		{
			// Lookup user name
			$urlInfo['user_id'] = DBSEO::reverseUsername($urlInfo['user_name']);
		}

		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['user_id']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		$data['userid'] = intval($data['bloguserid'] ? $data['bloguserid'] : $data['u']);
		if ($data['userid'])
		{
			// Grab our user info
			DBSEO::getUserInfo($data['userid']);
			$userInfo = DBSEO::$cache['userinfo'][$data['userid']];
		}
		
		if (!$userInfo['userid'])
		{
			// User didn't exist
			return '';
		}

		// Handle userid and username
		$replace['%user_id%'] 	= $userInfo['userid'];
		$replace['%user_name%'] = DBSEO::filterText($userInfo['username'], NULL, false, true, true);

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);
		
		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl,'://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}


// #############################################################################
// DBSEO "BlogFeedGlobal URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BlogFeedGlobal
{
	public static $format = 'Blog_BlogFeedGlobal';
	public static $structure = 'blog_external.php';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return (is_null($structure) ? self::$structure : $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Handle the replacements
		$newUrl = $rawFormat;
		
		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl,'://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}


// #############################################################################
// DBSEO "BlogsByDay_User URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BlogsByDay_User
{
	public static $format = 'Blog_BlogsByDay_User';
	public static $structure = 'blog.php?u=%d&y=%d&m=%d&d=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		if (empty($urlInfo['user_id']) AND isset($urlInfo['user_name']))
		{
			// Lookup user name
			$urlInfo['user_id'] = DBSEO::reverseUsername($urlInfo['user_name']);
		}

		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['user_id'], $urlInfo['year'], $urlInfo['month'], $urlInfo['day']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		$data['userid'] = intval($data['bloguserid'] ? $data['bloguserid'] : $data['u']);
		if ($data['userid'])
		{
			// Grab our user info
			DBSEO::getUserInfo($data['userid']);
			$userInfo = DBSEO::$cache['userinfo'][$data['userid']];
		}
		
		if (!$userInfo['userid'])
		{
			// User didn't exist
			return '';
		}

		// Handle userid and username
		$replace['%user_id%'] 	= $userInfo['userid'];
		$replace['%user_name%'] = DBSEO::filterText($userInfo['username'], NULL, false, true, true);

		if ($data['y'])
		{
			$replace['%year%'] 	= $data['y'];
			$replace['%month%'] = $data['m'];
			$replace['%day%'] 	= $data['d'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);
		
		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl,'://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}


// #############################################################################
// DBSEO "BlogsByMonth_User URL" class

/**
* Lets you construct & lookup custom URLs
*/
class DBSEO_Rewrite_BlogsByMonth_User
{
	public static $format = 'Blog_BlogsByMonth_User';
	public static $structure = 'blog.php?u=%d&y=%d&m=%d';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		if (empty($urlInfo['user_id']) AND isset($urlInfo['user_name']))
		{
			// Lookup user name
			$urlInfo['user_id'] = DBSEO::reverseUsername($urlInfo['user_name']);
		}

		return sprintf((is_null($structure) ? self::$structure : $structure), $urlInfo['user_id'], $urlInfo['year'], $urlInfo['month']);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Init this
		$replace = array();

		$data['userid'] = intval($data['bloguserid'] ? $data['bloguserid'] : $data['u']);
		if ($data['userid'])
		{
			// Grab our user info
			DBSEO::getUserInfo($data['userid']);
			$userInfo = DBSEO::$cache['userinfo'][$data['userid']];
		}
		
		if (!$userInfo['userid'])
		{
			// User didn't exist
			return '';
		}

		// Handle userid and username
		$replace['%user_id%'] 	= $userInfo['userid'];
		$replace['%user_name%'] = DBSEO::filterText($userInfo['username'], NULL, false, true, true);
		
		if ($data['y'])
		{
			$replace['%year%'] 	= $data['y'];
			$replace['%month%'] = $data['m'];
			$replace['%day%'] 	= $data['d'];
		}

		// Handle the replacements
		$newUrl = str_replace(array_keys($replace), $replace, $rawFormat);
		
		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl,'://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}


// #############################################################################
// DBSEO "Blogs" classes

/**
* Lets you construct & lookup Blogs URLs
*/
class DBSEO_Rewrite_Blogs
{
	public static $format = 'Blog_Blogs';
	public static $structure = 'blog.php';

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function resolveUrl($urlInfo = array(), $structure = NULL)
	{
		return (is_null($structure) ? self::$structure : $structure);
	}

	/**
	 * Creates a SEO'd URL based on the URL fed
	 *
	 * @param string $url
	 * @param array $data
	 * 
	 * @return string
	 */
	public static function createUrl($data = array(), $format = NULL)
	{
		if (!count(DBSEO::$cache['rawurls']))
		{
			// Ensure we got this kickstarted
			DBSEO::initUrlCache();
		}

		// Prepare the regexp format
		$format 		= explode('_', (is_null($format) ? self::$format : $format), 2);
		$rawFormat 		= DBSEO::$cache['rawurls'][strtolower($format[0])][$format[1]];

		// Handle the replacements
		$newUrl = $rawFormat;
		
		/*DBTECH_PRO_START*/
		if (DBSEO::$config['dbtech_dbseo_custom_blog'] AND strpos($newUrl,'://') === false)
		{
			// Use a custom blog domain
			$newUrl = DBSEO::$config['dbtech_dbseo_custom_blog'] . $newUrl;
		}
		/*DBTECH_PRO_END*/

		//if (strpos($newUrl, '%') !== false)
		//{
			// We should not return true if any single URL remains
			//return '';
		//}

		// Return the new URL
		return $newUrl;
	}
}